/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.server;

import io.github.jasonsimpart.createdelightcore.CDConfig;
import java.util.HashMap;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="createdelightcore", value={Dist.DEDICATED_SERVER})
public class ItemEntityEvent {
    private static int lastRunTime = 0;

    public static Chunk worldToChunk(String dimension, int x, int z) {
        return new Chunk(dimension, x >> 4, z >> 4);
    }

    @SubscribeEvent
    public static void serverTickEvent(TickEvent.ServerTickEvent event) {
        long preTime = 6000L;
        if ((long)event.getServer().m_129921_() % preTime == 0L) {
            if (CDConfig.disableDropReport) {
                return;
            }
            if (lastRunTime == event.getServer().m_129921_()) {
                return;
            }
            lastRunTime = event.getServer().m_129921_();
            HashMap<Chunk, Integer> worldEntityCount = new HashMap<Chunk, Integer>();
            Iterable loadedWorlds = event.getServer().m_129785_();
            loadedWorlds.forEach(world -> {
                List<ItemEntity> collect = StreamSupport.stream(world.m_142646_().m_142273_().spliterator(), false).filter(entity -> entity instanceof ItemEntity).map(entity -> (ItemEntity)entity).toList();
                collect.forEach(itemEntity -> {
                    int count;
                    Chunk chunk = ItemEntityEvent.worldToChunk(world.m_46472_().m_135782_().toString(), (int)itemEntity.m_20185_(), (int)itemEntity.m_20189_());
                    int n = count = CDConfig.ignoreStackCount ? 1 : itemEntity.m_32055_().m_41613_();
                    if (worldEntityCount.containsKey(chunk)) {
                        worldEntityCount.put(chunk, (Integer)worldEntityCount.get(chunk) + count);
                    } else {
                        worldEntityCount.put(chunk, count);
                    }
                });
            });
            boolean[] isStart = new boolean[]{false};
            worldEntityCount.forEach((chunk, count) -> {
                System.out.println("chunk: " + chunk.x + " " + chunk.z + " count: " + count);
                if (count > CDConfig.itemThreshold) {
                    if (!isStart[0]) {
                        isStart[0] = true;
                        event.getServer().m_6846_().m_11314_().forEach(player -> player.m_213846_((Component)Component.m_237113_((String)"\u6389\u843d\u7269\u62a5\u544a: ")));
                    }
                    event.getServer().m_6846_().m_11314_().forEach(player -> player.m_213846_((Component)Component.m_237113_((String)("World: " + chunk.dimension() + " Chunk: [" + chunk.x + ", " + chunk.z + "] count: " + count))));
                }
            });
        }
    }

    private record Chunk(String dimension, int x, int z) {
    }
}

